<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<!-- Generates Package NavBar -->
	<xsl:template name="PackageNavBar">
		<xsl:param name="package"></xsl:param>
		<xsl:param name="header"></xsl:param>
	
		<!-- Calculate relative path prefix -->
		<xsl:variable name="relativePrefix">
			<!--xsl:call-template name="RelativePathPrefix">
				<xsl:with-param name="element" select="$package"></xsl:with-param>
			</xsl:call-template-->
			<xsl:call-template name="GetCurrentPrefix"/>
		</xsl:variable>		
	
		<!-- Main Table -->		
		<table border="0" width="100%" cellpadding="1" cellspacing="0">
		<tr>
		<td colspan="2" class="NavBarCellCommon">
		<table border="0" cellpadding="0" cellspacing="3">
		<tr align="center" valign="top">

		<!-- OverView -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gOverview"></xsl:with-param>
			<xsl:with-param name="link" select="'overview-summary.html'"></xsl:with-param>
			<xsl:with-param name="relativePrefix" select="$relativePrefix"></xsl:with-param>
		</xsl:call-template>

		<!-- Package -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gPackage"></xsl:with-param>
			<xsl:with-param name="bold" select="'true'"></xsl:with-param>
		</xsl:call-template>
		
		<!-- Class -->
		<xsl:call-template name="NavBarCell">
			<xsl:with-param name="name" select="$gClass"></xsl:with-param>
		</xsl:call-template>

		<!-- Use -->
		<xsl:if test="$use_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gUse"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Tree -->
		<xsl:if test="$tree_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gTree"></xsl:with-param>
				<xsl:with-param name="link" select="'package-tree.html'"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Index - ALL -->
		<xsl:if test="$index_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gIndex"></xsl:with-param>
				<xsl:with-param name="link" select="'index-all.html'"></xsl:with-param>
				<xsl:with-param name="relativePrefix" select="$relativePrefix"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		<!-- Help -->
		<xsl:if test="$help_param">
			<xsl:call-template name="NavBarCell">
				<xsl:with-param name="name" select="$gHelp"></xsl:with-param>
				<xsl:with-param name="link" select="'help-doc.html'"></xsl:with-param>
				<xsl:with-param name="relativePrefix" select="$relativePrefix"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>

		</tr>
		</table>
		<!-- End of Main Table-->
		
		<xsl:call-template name="header_footer">
			<xsl:with-param name="header" select="$header"></xsl:with-param>
		</xsl:call-template>
		
		</td>
		</tr>
		
		<!-- Second Row Items -->
		<tr>
		
		<!-- Prev Next items-->
		<td class="NavBarCellPrevNext">
		<font size="-2">
		<xsl:variable name="prev">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'PrevPackage'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="next">
			<xsl:call-template name="getLocalizedResource">
				<xsl:with-param name="code" select="'NextPackage'"></xsl:with-param>
			</xsl:call-template>
		</xsl:variable>
		
		<!-- Insert reference to previous package -->
		<xsl:variable name="prevPackage" select="preceding-sibling::Package[1]"></xsl:variable>
		<xsl:choose>
			<xsl:when test="$prevPackage">
				<xsl:apply-templates select="$prevPackage" mode="HRefWithImgLoad">
					<xsl:with-param name="isName" select="'2'"/>
					<xsl:with-param name="useName" select="$prev"/>
				</xsl:apply-templates>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$prev"></xsl:value-of>
				<xsl:text disable-output-escaping="yes">&amp;nbsp;&amp;nbsp;</xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		
		<!-- Insert reference to next package -->
		<xsl:variable name="nextPackage" select="following-sibling::Package[1]"></xsl:variable>
		<xsl:choose>
			<xsl:when test="$nextPackage">
				<xsl:apply-templates select="$nextPackage" mode="HRefWithImgLoad">
					<xsl:with-param name="isName" select="'2'"/>
					<xsl:with-param name="useName" select="$next"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$next"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>

		</font>
		</td>

		<!-- Frames -->
		<xsl:call-template name="Frames">
			<xsl:with-param name="ref" select="'package-summary.html'"></xsl:with-param>
			<xsl:with-param name="relativePrefix" select="$relativePrefix"></xsl:with-param>
		</xsl:call-template>
		</tr>

		</table>
	
	</xsl:template>
</xsl:stylesheet>
